package com.icetech.partner.domain.request.open;

import com.icetech.common.annotation.NotNull;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 车辆信息修改接口
 * @author  fangct
 */
@Data
public class ModifyOrderRequest implements Serializable {
    /**
     * 云平台停车场编码
     */
    @NotNull
    @ApiModelProperty(value = "停车场编号，由平台统一分配", example = "P100122", position = 1)
    private String parkCode;

    /**
     *云平台订单号
     */
    @NotNull
    @NotBlank(message = "云平台订单号不能为空")
    @ApiModelProperty(value = "云平台订单号", example = "D1000000", required = true, position = 2)
    private String orderNum;

    /**
     * 新车牌号
     */
    @NotNull
    @ApiModelProperty(value = "新车牌号", example = "京A8888", position = 4)
    private String newPlateNum;

}
