package com.icetech.partner.domain.request.open;

import com.icetech.common.annotation.NotNull;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 出场通知接口
 * @author fangct
 */
@Setter
@Getter
@ToString
public class ExitSyncRequest implements Serializable {
    /**
     * 车场编号
     */
    @NotNull
    @NotBlank(message = "停车场编号不能为空")
    @ApiModelProperty(value = "停车场编号", required = true, example = "P100000", position = 1)
    private String parkCode;
    /**
     * 通道编号
     */
    @NotNull
    @NotBlank(message = "通道编号不能为空")
    @ApiModelProperty(value = "通道编号", required = true, example = "C100000", position = 2)
    private String channelCode;
    /**
     * 车牌号
     */
    @NotNull
    @NotBlank(message = "车牌号不能为空")
    @ApiModelProperty(value = "车牌号", required = true, example = "京A123456", position = 3)
    private String plateNum;
    /**
     * 出场时间，UNIX时间戳
     */
    @NotNull
    @javax.validation.constraints.NotNull(message = "出场时间不能为空")
    @ApiModelProperty(value = "出场时间", required = true, example = "1627800000", position = 4)
    private Long exitTime;

    @NotNull
    @NotBlank(message = "实收金额不能为空")
    @ApiModelProperty(value = "实收金额，单位元", required = true, example = "1.00", position = 5)
    private String paidPrice;

    //@NotNull
    @javax.validation.constraints.NotNull(message = "支付方式不能为空")
    @ApiModelProperty(value = "支付方式", required = true, example = "1", position = 6)
    private Integer payWay;

    /**
     * 三方订单号
     */
    private String orderNum;
}
