package com.icetech.partner.domain.request.open;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author zhangpengzhan
 * @date 2021/1/18 10:42
 * @description:设备告警信息接口
 */
@Data
public class DeviceStatusInfoRequest implements Serializable {
    /**
     * 类型(0：超级盒子 1：摄像头 2:道闸 4:语音对讲机)
     */
    @ApiModelProperty(value = "类型(0：超级盒子 1：摄像头 2:道闸 4:语音对讲机)", required = true, example = "1", position = 1)
    private Integer type;
    /**
     * 设备状态（设备状态,1在线2离线）
     */
    @ApiModelProperty(value = "设备状态（设备状态,1在线2离线）", required = true, example = "1", position = 2)
    private Integer deviceStatus;

    /**
     * 通道id
     */
    @ApiModelProperty(value = "通道编码", required = true, example = "C1000000", position = 3)
    private String channelCode;

    /**
     * 车场编码
     */
    @ApiModelProperty(value = "车场编码", required = true, example = "P1000000", position = 5)
    private String parkCode;

    /**
     * 原因描述
     */
    @ApiModelProperty(value = "原因描述", example = "未知异常", position = 6)
    private String remark;
    /**
     * 设备SN号
     */
    @ApiModelProperty(value = "设备序列号", example = "S100000", position = 7)
    private String serialNumber;

}
