package com.icetech.partner.domain.request.open;

import com.icetech.common.annotation.NotNull;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 优惠核销
 */

@Setter
@Getter
@ToString
public class CancelDiscountRequest implements Serializable {
    /**
     * 优惠券编号
     */

    @NotNull
    @NotBlank(message = "优惠编号不能为空")
    @ApiModelProperty(value = "优惠编号，必须同发放时的优惠编号一致", example = "Y100122", required = true, position = 1)
    String outDiscountNo;

    /**
     * 车场编号
     */
    @NotNull
    @NotBlank(message = "停车场编号不能为空")
    @ApiModelProperty(value = "停车场编号，由平台统一分配", example = "P100122", required = true, position = 2)
    String parkCode;

    /**
     * 订单号
     */
    @ApiModelProperty(value = "订单号", example = "111111", position = 3)
    String orderNum;

    /**
     * 车牌号
     */
    @NotNull
    @NotBlank(message = "车牌号不能为空")
    @ApiModelProperty(value = "车牌号", example = "京A88888", required = true, position = 4)
    String plateNum;
}
