package com.icetech.partner.domain.request.linyi;

import lombok.Data;

import java.io.Serializable;

/**
 * 临沂-支付记录
 */
@Data
public class LinYiPayRequest implements Serializable {
    /**
     * 机构号
     */
    private String instid;
    /**
     * 接入商户号
     */
    private String mchntid;
    /**
     * 停车场ID
     */
    private String psn;
    /**
     * yyyymmddhhmmss	请求时间
     */
    private String txntime;
    /**
     * 交易类型
     */
    private String  txncode;
    /**
     * 通讯流水号	yyyymmddhhmmsss+4位数(第三方车场没有则发送时自动生成)
     */
    private String seqid;
    /**
     *入场流水号	第三方车场系统的
     */
    private String inseqid;
    /**
     *事件类型
     * 详见数据字典
     */
    private String eventtype;

    /**
     *支付方式
     */
    private String paytype;
    /**
     *支付渠道	00：线下；01:线上代扣
     */
    private String paychnl;
    /**
     *支付状态	0：线上已扣不需要入账
     * 1或者其他：未扣（需要入账）
     */
    private String paystatus;
    /**
     *应收金额	单位:分
     */
    private Integer ysamt;
    /**
     *实收金额
     */
    private Integer shamt;

    /**
     *优惠金额
     */
    private Integer favamt;
    /**
     *0：正常记录，1：免费时间内，2：免费
     */
    private String freechargetype;
    /**
     *优惠明细（平台下发）
     * 对象数组:{[优惠类型:xxx,优惠ID:xxx,优惠值:xxx]},其中优惠类型字段采用字典：
     */
    private String favdetail;
    /**
     离场有效时间（yyyyMMddHHmmss）
     */
    private String endtime;
    /**
     *报文通讯mac
     */
    private String mac;
}
