package com.icetech.partner.domain.request.linyi;

import lombok.Data;

import java.io.Serializable;

/**
 * 临沂-代扣
 */
@Data
public class LinYiAutoRequest implements Serializable {
    /**
     * 机构号
     */
    private String instid = "10000020";
    /**
     * 接入商户号
     */
    private String mchntid = "1001930";
    /**
     * 停车场ID
     */
    private String psn = "lw01";
    /**
     * yyyymmddhhmmss	请求时间
     */
    private String txntime;
    /**
     * 通讯流水号	yyyymmddhhmmsss+4位数(第三方车场没有则发送时自动生成)
     */
    private String seqid;
    /**
     *入场流水号	第三方车场系统的
     */
    private String inseqid;

    /**
     *交易类型	orderpayreq
     */
    private String txncode;
    /**
     *代扣金额	单位:分
     */
    private Integer ysamt;
    /**
     *本次计费结束时间
     */
    private String endtime;
    /**
     *订单编号
     */
    private String orderno;
    /**
     *订单总金额	原始计费，单位为分
     */
    private String servicefee;
    /**
     *扣减金额	扣减金额，单位为分
     */
    private String deductfee;


    /**
     *优惠金额	优惠金额，单位为分
     *
     */
    private String discountfee;
    /**
     *免费分钟数	指缴费后需要在多久的时间内出场，否则将产生超时费用，单位为分钟
     */
    private String freeminute;
    /**
     *报文通讯mac
     */
    private String mac;
}
