package com.icetech.partner.domain.request.jindi;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 停车入库
 */
@Data
public class ParkingCarsRequest implements Serializable {
    @JsonProperty(value = "cars")
    private List<Map>  cars;
    @JsonProperty(value = "main_car")
    private String mainCar;
    @JsonProperty(value = "count")
    private Integer count;
    @JsonProperty(value = "lot_id")
    private String parkCode;
    @JsonProperty(value = "start_time")
    private Date startTime;
    @JsonProperty(value = "end_time")
    private Date endTime;
    @JsonProperty(value = "parking_type")
    private Integer parkingType;
    @JsonProperty(value = "payment_method")
    private Integer paymentMethod;
    @JsonProperty(value = "total_price")
    private Double totalPrice;
    @JsonProperty(value = "payment_time")
    private String paymentTime;
}
