package com.icetech.partner.domain.request.hangzhou;

import com.icetech.common.annotation.NotNull;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

/**
 * 停车场库本地系统定时向城市大脑停车系统上传心跳，获取服务器基准时钟，
 * 检查停车场库本地系统时钟是否准确。
 *
 * @author zhangpengzhan
 * @date 2020/8/18 10:05
 */
@Setter
@Getter
@ToString
public class UploadHeartbeatRequest {
    /**
     * 该编号在场
     * 库系统中保
     * 证唯一
     */
    @NotNull
    private String parkingCode;

    /**
     * 上传时间
     * （格式：
     * yyyy-MM-dd
     * HH:mm:ss）
     */
    @NotNull
    private String uploadTime;

    /**
     * 备注
     */
    private String remark;
}
