package com.icetech.partner.domain.request.hangzhou;

import com.icetech.common.annotation.NotNull;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;

/**
 * 杭州 城市大脑 上传车辆到达记录
 *
 * @author zhangpengzhan
 * @date 2020/8/16 10:24
 */
@Getter
@Setter
@ToString
public class UploadCarInData implements Serializable {
    /**
     * 一次车辆到达的流
     * 水号（场库编号+
     * 入口编号+时间戳
     * （yyyyMMddHHm
     * msssss）
     */
    @NotNull
    private String uid;

    /**
     * 场库系统给出的车
     * 辆到达记录 id
     */
    @NotNull
    private String arriveID;

    /**
     * 车牌号
     */
    @NotNull
    private String plateNo;

    /**
     * 该编号在场库系统
     * 中保证唯一
     */
    @NotNull
    private String parkingCode;

    /**
     * 岗亭编号
     */
    private String gateNo;

    /**
     * 场库入口的编号
     */
    @NotNull
    private String entryNum;

    /**
     * 收费员编号
     */
    private String operatorCode;

    /**
     * 泊位总数
     */
    @NotNull
    private Integer totalBerthNum;

    /**
     * 开放泊位数
     */
    @NotNull
    private Integer openBerthNum;

    /**
     * 剩余开放泊位数
     */
    @NotNull
    private Integer freeBerthNum;

    /**
     * 到达时间（格式：
     * yyyy-MM-dd
     * HH:mm:ss）
     */
    @NotNull
    private String arriveTime;

    /**
     * 停车类型
     */
    @NotNull
    private Integer parkingType;

    /**
     * 车牌颜色，参见数
     * 据字典
     */
    @NotNull
    private Integer plateColor;

    /**
     * 上传时间（格式：
     * yyyy-MM-dd
     * HH:mm:ss）
     */
    @NotNull
    private String uploadTime;
}
