package com.icetech.partner.domain.request.dongcheng;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * @author wanggang
 * @create 2024-02-23 10:55
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class BeiJingDongChengParamDTO implements Serializable {


    /**
     * 登录秘钥信息
     */
    private LoginParamDTO loginParamDTO;

    /**
     * 管理单位基本信息
     */
    private EnterpriseParamDTO enterpriseParamDTO;

    /**
     * 停车场备案信息
     */
    private ParkBeiAnParamDTO parkBeiAnParamDTO;

    /**
     * 停车场信息
     */
    private ParkParamDTO parkParamDTO;

    /**
     * 出入口基本信息
     */
    private List<EntranceParamDTO> entranceParamDTO;

    /**
     * 停车信息采集设备信息
     */
    private List<DeviceParamDTO> deviceParamDTO;

    /**
     * 收费标准清单
     */
    private List<ChargeStandardParamDTO> chargeStandardParamDTO;

    /**
     * 停车场泊位信息
     */
    private List<BerthParamDTO> berthParamDTO;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class LoginParamDTO implements Serializable {

        /**
         * 客户端ID
         */
        private String clientId;

        /**
         * 客户端秘钥
         */
        private String clientSecret;

        /**
         * 授权类型
         */
        private String grantType;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class EnterpriseParamDTO implements Serializable {

        /**
         * 管理单位名称
         */
        private String departmentName;

        /**
         * 组织结构代码
         */
        private String organizationCode;

        /**
         * 联系人
         */
        private String contact;

        /**
         * 联系电话
         */
        private String telephone;

        /**
         * 联系地址
         */
        private String address;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class ParkBeiAnParamDTO implements Serializable {

        /**
         * 停车场编号
         */
        private String parkSn;

        /**
         * 停车场名称
         */
        private String parkName;

        /**
         * 所属街道名称
         */
        private String streetName;

        /**
         * 停车场备案号
         */
        private String parkRecordNo;

        /**
         * 停车场类型
         */
        private String parkType;

        /**
         * 经营企业名称
         */
        private String enterpriseName;

        /**
         * 组织机构代码
         */
        private String organizationCode;

        /**
         * 停车场地址
         */
        private String location;

        /**
         * 地上平面车位数
         */
        private Integer surfacePlaneNum;

        /**
         * 地下平面车位数
         */
        private Integer landPlaneNum;

        /**
         * 地上机械式停车设施车位数
         */
        private Integer surfaceMechainNum;

        /**
         * 地下机械式停车设施车位数
         */
        private Integer landMechainNum;

        /**
         * 简易自走停车设施车位数
         */
        private Integer easySelfWalking;

        /**
         * 经营性车位数
         */
        private Integer operationalNum;

        /**
         * 总车位数
         */
        private Integer berthNum;

        /**
         * 地区类型
         */
        private String districtType;

        /**
         * 备案截止时间
         */
        private String endTime;

        /**
         * 管理单位负责人
         */
        private String charge;

        /**
         * 联系电话
         */
        private String telephone;

        /**
         * 新能源专用车位数
         */
        private Integer newEnergyNum;

        /**
         * 充电桩数目（快充）
         */
        private Integer quickChargePileNum;

        /**
         * 充电桩数目（慢充）
         */
        private Integer slowChargePileNum;

        /**
         * 残疾人车位数
         */
        private Integer disabledBerthNum;

        /**
         * 小型车车位数
         */
        private Integer smallCarNum;

        /**
         * 大型车位数
         */
        private Integer largeCarNum;

        /**
         * 竣工验收通过日期
         */
        private String buildCompletedTime;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class ParkParamDTO implements Serializable {

        /**
         * 停车场名称
         */
        private String parkName;

        /**
         * 停车场编号
         */
        private String parkSn;

        /**
         * 停车场类型
         */
        private Integer parkType;

        /**
         * 停车场地址
         */
        private String address;

        /**
         * 停车场产权方
         */
        private String parkOwner;

        /**
         * 停车场管理单位
         */
        private String departmentName;

        /**
         * 组织机构代码
         */
        private String organizationCode;

        /**
         * 停车场维护单位
         */
        private String maintainDepartment;

        /**
         * 联系人名称
         */
        private String contact;

        /**
         * 收费标准
         */
        private String chargeStandardfeeSn;

        /**
         * 总车位数
         */
        private Integer berthNum;

        /**
         * 专用车位数
         */
        private Integer specificBerthNum;

        /**
         * 可用车位数
         */
        private Integer availableBerthNum;

        /**
         * 错峰停车车位数
         */
        private Integer shareBerthNum;

        /**
         * 无障碍专用车位数
         */
        private Integer deformBerthNum;

        /**
         * 停车场进口数
         */
        private Integer entranceNum;

        /**
         * 停车场出口数
         */
        private Integer exitNum;

        /**
         * 停车场备案日期
         */
        private String applyDate;

        /**
         * 信息更新时间
         */
        private String updateTime;

        /**
         * 停车场开放时间
         */
        private String openTime;

        /**
         * 充电桩数量
         */
        private Integer chargePileNum;

        /**
         * 行政区代码
         */
        private String districtCode;

        /**
         * 所属街道
         */
        private String street;

        /**
         * 所属街道代码
         */
        private String streetCode;

        /**
         * 所在道路名称
         */
        private String roadName;

        /**
         * 服务属性
         */
        private Integer serviceType;

        /**
         * 机械车库编号
         */
        private String garageSn;

        /**
         * 所属派出所名称
         */
        private String policeOfficeName;

        /**
         * 区域负责民警
         */
        private String policeName;

        /**
         * 充电站名称
         */
        private String chargeStationName;

        /**
         * 停车场租赁有效期截止期
         */
        private String rentDate;

        /**
         * 停车场产权
         */
        private Integer ownType;

        /**
         * 从业人员数量
         */
        private Integer staffNum;

        /**
         * 是否已备案
         */
        private Integer hasApply;

        /**
         * 停车场入口经度
         */
        private Double longitude;

        /**
         * 停车场入口纬度
         */
        private Double latitude;

        /**
         * 所属环路位置
         */
        private String belongDistrict;

        /**
         * 信息系统服务商统一社会信用代码
         */
        private String infoServiceSn;

        /**
         * 信息系统服务商名称
         */
        private String infoServiceName;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class EntranceParamDTO implements Serializable {

        /**
         * 出入口编号
         */
        private String crSn;


        /**
         * 出入口名称
         */
        private String crName;

        /**
         * 所属停车场编号
         */
        private String parkSn;

        /**
         * 所属机械车库编号
         */
        private String mechanicsSn;

        /**
         * 连接道路名称
         */
        private String relatePositionName;

        /**
         * 出入口类型:1：仅入口；2：仅出口；3：出入口
         */
        private Integer crType;

        /**
         * 所处位置经度
         */
        private Double positionLong;

        /**
         * 所处位置纬度
         */
        private Double positionLat;

        /**
         * 安装设备编号
         */
        private Double deviceSn;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class DeviceParamDTO implements Serializable {

        /**
         * 采集设备编号
         */
        private String deviceSn;

        /**
         * 采集设备厂商名称
         */
        private String deviceName;

        /**
         * 所属停车场编号
         */
        private String parkSn;

        /**
         * 采集设备类型
         */
        private String deviceType;

        /**
         * 覆盖停车位编号
         */
        private String berthSn;

        /**
         * 连接状态
         */
        private Integer relateStatus;

        /**
         * 工作状态
         */
        private Integer workStatus;

        /**
         * 工作温度
         */
        private Integer workTemperatuer;

        /**
         * 上传时间间隔
         */
        private Integer timeInterval;

        /**
         * 即时上传数据阈值
         */
        private Integer threshold;

        /**
         * 重连时间间隔
         */
        private Integer reconnectInterval;

        /**
         * 重连次数
         */
        private Integer reconnectNum;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class ChargeStandardParamDTO implements Serializable {

        /**
         * 收费标准编号
         */
        private String feeSn;

        /**
         * 停车场编号
         */
        private String parkSn;

        /**
         * 停车场备案号
         */
        private String parkRecordNo;

        /**
         * 收费单位
         */
        private String chargeDepartment;

        /**
         * 定价方式
         */
        private Integer priceWay;

        /**
         * 区域划分
         */
        private Integer districtDistribute;

        /**
         * 价格投诉电话
         */
        private String complainTel;

        /**
         * 收费标价牌图片
         */
        private String picture;

        /**
         * 收费标准描述
         */
        private String chargeItem;

        /**
         * 补充说明
         */
        private String info;

        /**
         * 临停小型车白天
         * 单价
         */
        private Integer tempSmallCarDayPrice;

        /**
         * 临停小型车夜间
         * 单价
         */
        private Integer tempSmallCarNightPrice;

        /**
         * 临停大型车白天
         * 单价
         */
        private Integer tempBigCarDayPrice;

        /**
         * 临停大型夜间单
         * 价
         */
        private Integer tempBigCarNightPrice;

        /**
         * 长包小型车单价
         */
        private Integer leaseSmallCarPrice;

        /**
         * 长包大型车单价
         */
        private Integer leaseBigCarPrice;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class BerthParamDTO implements Serializable {

        /**
         * 泊位编号
         */
        private String berthSn;

        /**
         * 停车场编号
         */
        private String parkSn;

        /**
         * 停车位使用状态：“0”表示
         * 不可用；“1”表示可用
         */
        private Integer status;

        /**
         * 经营类型0：分时；1：长期包月；2：
         * 限时段包月；3：已售；4：
         * 专用车位
         */
        private Integer economicType;

        /**
         * 产权类型1：个人；2：单位；3：其他
         */
        private Integer owenerType;

        /**
         * 位置类型0：路内；1：路外室内；2：
         * 路外室外
         */
        private Integer locationType;

        /**
         * 尺寸类型1：微型；2：紧凑型；3：中
         * 型；4：大型
         */
        private Integer sizeType;

        /**
         * 形态类型0：普通车位（平面自走式）；
         * 1：机械车库车位
         */
        private Integer formType;

        /**
         * 1：商业；2：住宅；3：医院；
         * 4：园区；5：交通枢纽；6：
         * 行政机关；7：学校；8：其他
         */
        private Integer useType;

        /**
         * 出行性质0：居住车位；1：出行车位；
         * 2：居住和出行兼用；3：未
         * 知
         */
        private Integer tripPropertity;

        /**
         * 采集设备编号停车位所对应的信息采集设
         * 备编号
         */
        private String deviceSn;

        /**
         * 临停小型车夜间
         * 单价
         */
        private String deviceType;

        /**
         * 配置充电桩编
         * 号
         */
        private String elePileSn;

        /**
         * 所属停车场名
         * 称
         */
        private String parkName;

    }
}
