package com.icetech.partner.domain.request.bst;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * @author wanggang
 * @create 2023-06-14 17:04
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class BstParkInfoVo implements Serializable {

    /**
     * 车场名称
     * 字符串（30位）
     */
    private String name;

    /**
     * 停车场编号，流量主自己内部的车场Id，同一流量主下各车场编号不允许重复
     * 字符串（20位）
     */
    private String parKNumber;

    /**
     * 车场类型 0:商场，1:写字楼，2 ：住宅小区，3：医院，4：酒店宾馆，5 ：风景区，6 ：游乐场，7 ：学校，8 ：交通枢纽，9：机关事业单位，10：剧院；11：道边车场；12：办公园区；13：物流园
     */
    private String parkType;

    /**
     * 详细地址，同经纬度一致，须精确到市区
     */
    private String address;

    /**
     * 地区编号，影响广告获取时的匹配和详细地址address一致。参见地区编号列表(平台自定义，不要用微信或其他平台的编号)
     */
    private String areaCode;

    /**
     * 经度，影响播放广告的匹配，需精确。不清楚时为0即可
     */
    private Double lon;

    /**
     * 纬度，影响播放广告的匹配，需精确。不清楚时为0即可
     */
    private Double at;

    /**
     * 联系人
     */
    private String contactPerson;

    /**
     * 联系电话
     */
    private String contactPhone;

    /**
     * 广告位集合
     */
    private List<BstAdSpaceVo> adSpaces;

    /**
     * 指在广告位集合为空时，是否要求系统自动创建默认广告位。默认为false
     */
    private Boolean autoDefaultAd;
}
