package com.icetech.partner.domain.request;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Map;

/**
 * Description BstAdBidResponse
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2023/6/14 14:39
 */
@Data
public class BstAdBidRequest implements Serializable {

    /**
     * 请求Id. 客户端生成，和通用参数部分的requestId一致。
     */
    private String requestId;

    /**
     * 底价，单位元。无的话从广告位注册信息中获取，有的话则覆盖。在商务谈好的情况下，建议此值明确为一个极小值0.0001（不能为0,为0 表示继承车场或流量主上的值）,防范有获取不到广告的情况
     */
    private Double bidFloor;

    /**
     * 车牌号
     */
    private String plateNumber;

    /**
     * 车牌颜色
     */
    private String plateColor;

    /**
     * 车辆颜色
     */
    private String vehicleColor;

    /**
     * 车辆品牌
     */
    private String vehicleBrand;

    /**
     * 停车时间（分钟）
     */
    private Integer parkingDuration;

    /**
     * 广告位展示宽度
     */
    private Integer width;

    /**
     * 广告位展示高度
     */
    private Integer height;

    /**
     * 广告位关联设备,参考对象说明文档
     */
    private BstDevice device;
    
    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class BstDevice implements Serializable {

        /**
         * ip
         */
        private String ip;

        /**
         * ua
         */
        private String ua;
    }
}
