package com.icetech.partner.domain.piaotong;

import lombok.Data;

@Data
public class PiaoTongResponse {

    /**
     * 响应状态
     * 4-6 位
     * 是
     * 业务返回码
     */
    protected String code;
    /**
     * 响应消息
     * 0-60 位
     * 否
     * 业务返回码描述
     */
    protected String msg;
    /**
     * 签名串
     * 256 位
     * 是
     */
    protected String sign;
    /**
     * 交易请求流水号
     * 26 位
     * 是
     */
    protected String serialNo;
    /**
     * 业务报文内容
     * 不定长
     * 是
     * 3DES 加密
     */
    protected String content;

    public static PiaoTongResponse success() {
        return success(null);
    }

    public static PiaoTongResponse success(String serialNo) {
        PiaoTongResponse response = new PiaoTongResponse();
        response.setSerialNo(serialNo);
        response.setCode(PiaoTongConstants.RESPONSE_CODE_SUCCESS);
        response.setMsg("成功");
        return response;
    }

    public static PiaoTongResponse failed() {
        return failed("失败");
    }

    public static PiaoTongResponse failed(String msg) {
        return failed(null, msg);
    }

    public static PiaoTongResponse failed(String serialNo, String msg) {
        return failed(serialNo, PiaoTongConstants.RESPONSE_CODE_FAILED, msg);
    }

    public static PiaoTongResponse failed(String serialNo, String code, String msg) {
        PiaoTongResponse response = new PiaoTongResponse();
        response.setSerialNo(serialNo);
        response.setCode(code);
        response.setMsg(msg);
        return response;
    }

    public static String getSignContent(PiaoTongResponse response) {
        return "code=" + response.getCode()
                + "&content=" + response.getContent()
                + "&msg=" + response.getMsg()
                + "&serialNo" + response.getSerialNo();
    }
}
