package com.icetech.partner.domain.piaotong;

import java.util.Date;
import java.util.Random;

import com.icetech.common.utils.DateUtils;
import lombok.Data;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

@Data
public class PiaoTongRequest {
    /**
     * 平台编码
     * 8位 是
     * 票通分配给开发者的平台编码
     */
    protected String platformCode;
    /**
     * 加密类型
     * 10位 是
     * 目前支持RSA
     */
    protected final String signType = "RSA";
    /**
     * 签名串
     * 256位 是
     * 商户请求参数的签名串
     */
    protected String sign;
    /**
     * 业务报文格式
     * 10位 否
     * 目前支持JSON
     */
    protected final String format = "JSON";
    /**
     * 请求时间
     * 19位 是
     * yyyy-MM-dd HH:mm:ss
     */
    protected String timestamp;
    /**
     * 版本号
     * 4位 是
     * 调用接口版本，固定为1.0
     */
    protected final String version = "1.0";
    /**
     * 交易请求流水号
     * 26位 是
     * 4位平台简称＋14位日期(yyyymmddhhmmss)+8位随机数（通过SDK生成）
     */
    protected String serialNo;
    /**
     * 业务报文内容
     * 不定长 是
     * 请求参数的集合，最大长度不限，除公共参数外所有请求参数都必须放在这个参数中传递
     */
    protected String content;

    public static String getSignContent(PiaoTongRequest request) {
        return "content=" + request.getContent()
                + "&format=" + request.getFormat()
                + "&platformCode=" + request.getPlatformCode()
                + "&serialNo=" + request.getSerialNo()
                + "&signType=" + request.getSignType()
                + "&timestamp=" + request.getTimestamp()
                + "&version=" + request.getVersion();
    }

    public static PiaoTongRequest getInstance(String platformCode, String platformAlias) {
        PiaoTongRequest request = new PiaoTongRequest();
        request.setPlatformCode(platformCode);
        Date now = new Date();
        request.setTimestamp(DateFormatUtils.format(now, "yyyy-MM-dd HH:mm:ss"));
        Random random = new Random(System.currentTimeMillis());
        StringBuilder builder = new StringBuilder(8);
        for (int i = 0; i < 8; i++) {
            builder.append(random.nextInt(10));
        }
        String serialNo = platformAlias + DateFormatUtils.format(new Date(), "yyyyMMddHHmmss") + builder;
        request.setSerialNo(serialNo);
        return request;
    }
}
