package com.icetech.partner.domain.piaotong;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

// (\w+)\t(\S+)\t(\S+)\t(\S)\t(\S+)
// /**\n*$2\n*$3\n*$4\n*$5\n*/\nprotected String $1;
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
public class InvoiceBlueFullRequest extends InvoiceBlueRequest {
    public static final String INVOICE_ISSUE_KIND_CODE_FULL_SIMPLE = "82";
//    itemName
//    casherName
//    reviewerName
//    drawerName
//    extensionNum
//    machineCode
//    agentInvoiceFlag
    /**
     * 开具发票种类
     * String(1-2)
     * 是
     * 开具发票种类。81：全电发票（增值税专用发票）82：全电发票（普通发票）
     */
    protected String invoiceIssueKindCode;
    /**
     * 是否开具给自然人
     * String（1）
     * 否
     * 是否开具给自然人。默认0。0：否；1：是。电子税局勾选“是”时的提示：请您确认受票方为自然人，并在纳税人识别号档次填入“自然人纳税人识别号”(自然人受票方可登录个人所得税APP查看“自然人纳税人识别号”)，该张发票将在受票方自然人个人票夹中展示。
     */
    protected String naturalPersonFlag;
    /**
     * 开票人税局账号
     * String(50)
     * 否
     * 电子税局登录账号（手机号或身份证号），必须是通过2.1接口进行用户登记的账号。如果不填，随机取已在票通平台登记的账号。
     */
    protected String account;
    /**
     * 全电发票差额征税标识
     * String（1）
     * 否
     * 全电发票差额征税标识。1：差额征税-全额开票
     */
    protected String variableLevyFlag;

    /**
     * 是否显示购方开户行及账号到发票备注
     * 是否显示购方开户行及账号到发票备注，默认 0 不显示
     * 0: 不显示
     * 1: 显示
     */
    protected String showBuyerBank;
    /**
     * 是否显示销方开户行及账号到发票备注
     * 是否显示销方开户行及账号到发票备注，默认0不显示
     * 0:不显示
     * 1:显示
     * 注：最终版式文件销方银行账户取税局维护的开户行及账号
     */
    protected String showSellerBank;

    /** 特定业务--不动产经营租赁服务（realEstateRentalService），不动产经营租赁服务相关的税收分类编码，必填 */
    protected RealEstateRental realEstateRentalService;

    /** 不动产租赁信息 */
    @Data
    @Accessors(chain = true)
    public static class RealEstateRental {
        /**
         * 省市（县）区
         * String（4-50）
         * 是
         * 不动产所在省市（县）区。例如：上海市黄浦区/四川省绵阳市涪城区/广东省河源市和平县
         */
        protected String region;
        /**
         * 详细地址
         * String（1-100字符）
         * 是
         * 不动产详细地址。例如：东江北路68 号
         */
        protected String detailedAddress;
        /**
         * 面积单位
         * String
         * 是
         * 面积单位。平方千米平方米公顷亩h ㎡k ㎡㎡
         */
        protected String areaUnit;
        /**
         * 跨地(市)标志
         * String(1)
         * 是跨地(市)标志。0：否；1：是
         */
        protected String crossCitySign;
        /**
         * 租赁期起止
         * String(21)
         * 是
         * 租赁期起止。例如2022-12-01 2022-12-12
         */
        protected String leaseTerm;
        /**
         * 产权证书/不动产权号
         * String（0-40 字符）
         * 否
         * 产权证书/不动产权号。若没有证书填写“无”。
         */
        protected String titleNo;

        /**
         * 起始时间
         */
        protected String startDate;

        /**
         * 终止时间
         */
        protected String endDate;
    }

//    @Data
//    @Accessors(chain = true)
//    @EqualsAndHashCode(callSuper = true)
//    public static class Item2 extends InvoiceBlueRequest.Item {
//        // deductionAmount
//    }
}
