package com.icetech.partner.domain.nuonuo;


import java.util.regex.Pattern;

public class NuoNuoConstant {

    /**
     * Redis Key - 诺诺发票 AccessToken
     */
    public static final String REDIS_NUO_NUO_INVOICE_TOKEN = "nuo:invoice:token";

    /**
     * Token 过期时间减少秒数，避免临界过期
     */
    public static final int TOKEN_EXPIRE_REDUCE_SECONDS = 5 * 60;

    /**
     * 诺诺开票接口方法名 - 新版开票
     */
    public static final String API_BULLING_NEW = "nuonuo.OpeMplatform.requestBillingNew";

    /**
     * 诺诺发票结果查询接口方法名
     */
    public static final String API_INVOICE_RESULT = "nuonuo.OpeMplatform.queryInvoiceResult";

    /**
     * 诺诺接口响应成功码
     */
    public static final String RESPONSE_CODE_SUCCESS = "E0000";

    /**
     * 诺诺发票查询接口 - 发票状态成功码
     */
    public static final String RESPONSE_STATUS_SUCCESS = "2";

    /**
     * 诺诺发票查询接口 - 发票状态开票中
     */
    public static final String RESPONSE_INVOICE_ING = "20";

    /**
     * 诺诺发票查询接口 - 发票状态开票成功签章中
     */
    public static final String RESPONSE_INVOICE_SIGNATURE = "21";

    /**
     * 诺诺发票查询接口 - 发票状态开票失败
     */
    public static final String RESPONSE_STATUS_FAILED = "22";

    /**
     * 诺诺发票查询接口 - 发票状态开票成功签章失败
     */
    public static final String RESPONSE_STATUS_FAILED_SIGNATURE = "24";

    /**
     * 诺诺发票查询接口 - 发票状态开票成功签章失败
     */
    public static final String RESPONSE_STATUS_DEL = "31";

    /**
     * 发票类型 - 蓝票
     */
    public static final String INVOICE_TYPE_BLUE = "1";

    /**
     * 发票明细 - 单价含税标志 - 不含税
     */
    public static final String WITH_TAX_FLAG_NO = "0";

    /**
     * 发票明细 - 单价含税标志 - 含税
     */
    public static final String WITH_TAX_FLAG_YES = "1";

    /**
     * 优惠政策标识 - 不使用
     */
    public static final String FAVOURED_POLICY_FLAG_NO = "0";

    /**
     * 优惠政策标识 - 使用
     */
    public static final String FAVOURED_POLICY_FLAG_YES = "1";

    /**
     * 零税率标识 - 非零税率
     */
    public static final String ZERO_RATE_FLAG_NO = "";

    /**
     * 零税率标识 - 免税
     */
    public static final String ZERO_RATE_FLAG_FREE_TAX = "1";

    /**
     * 零税率标识 - 不征税
     */
    public static final String ZERO_RATE_FLAG_NON_TAXABLE = "2";

    /**
     * 零税率标识 - 出口零税率
     */
    public static final String ZERO_RATE_FLAG_EXPORT_ZERO_TAX = "3";

    /**
     * 增值税特殊管理类型 - 免税
     */
    public static final String FAVOURED_POLICY_NAME_FREE_TAX = "免税";

    /**
     * 增值税特殊管理类型 - 简易征收
     */
    public static final String FAVOURED_POLICY_NAME_SIMPLE_COLLECTION = "简易征收";

    /**
     * 发票详情查询接口 - 是否需要发票明细 - 是
     */
    public static final String INVOICE_RESULT_DETAIL_YES = "1";

    public static final String DATE_PATTERN = "yyyy-MM-dd";

    public static final String DATE_PATTERN_HH_MM = "yyyy-MM-dd HH:mm";

    public static final Pattern MONTH_DATE_REGEX = Pattern.compile("^续费时间[：:](\\d{4})[-/年](\\d{2})[-/月](\\d{2})日?-(\\d{4})[-/年](\\d{2})[-/月](\\d{2})日?$");

}