package com.icetech.partner.domain.model.kuangu;

import java.util.List;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
public class NewInvoiceResultResponse {
    protected String code;
    protected String msg;
    protected Data data;

    @Getter
    @Setter
    @ToString
    @Accessors(chain = true)
    public static class Data {
        /**
         * 发票信息列表 是
         */
        protected List<InvoiceData> InvoiceList;
    }

    @Getter
    @Setter
    @ToString
    @Accessors(chain = true)
    public static class InvoiceData {
        public static final String STATE_NEW = "0";
        public static final String STATE_SUCCESS = "1";
        public static final String STATE_FAILED = "-1";

        /**
         * 税控装置编号
         */
        protected String UDiskSn;
        /**
         * 开票类型
         */
        protected String IssueType;
        /**
         * 发票种类
         */
        protected String InvoiceType;
        /**
         * 发票代码
         */
        protected String InvoiceCode;
        /**
         * 发票号码
         */
        protected String InvoiceNum;
        /**
         * 销方纳税人识别号
         */
        protected String MerchantTaxID;
        /**
         * 销方名称
         */
        protected String MerchantName;
        /**
         * 销方地址电话
         */
        protected String MerchantAddress;
        /**
         * 销方银行及账号
         */
        protected String MerchantBank;
        /**
         * 购方纳税人识别号
         */
        protected String PurchaserTaxID;
        /**
         * 购方名称
         */
        protected String PurchaserName;
        /**
         * 购方地址电话
         */
        protected String PurchaserAddr;
        /**
         * 购方银行及账号
         */
        protected String PurchaserBank;
        /**
         * 购方邮箱
         */
        protected String PurchaserEmail;
        /**
         * 购方手机号码
         */
        protected String PurchaserMobile;
        /**
         * 合计金额(不含税)
         */
        protected String TotalAmountTaxExcluded;
        /**
         * 合计税额
         */
        protected String TotalTax;
        /**
         * 价税合计
         */
        protected String TotalAmount;
        /**
         * 汇总行税率
         */
        protected String SummaryTaxRate;
        /**
         * 备注
         */
        protected String Remarks;
        /**
         * 收款人
         */
        protected String Payee;
        /**
         * 复核人
         */
        protected String Reviewer;
        /**
         * 开票人
         */
        protected String Drawee;
        /**
         * 清单标志
         */
        protected String ListFlag;
        /**
         * 征收类型
         */
        protected String LevyingType;
        /**
         * 税率选择原因
         */
        protected String TaxRateReason;
        /**
         * 是否代办退税
         */
        protected String IsCommissionRebate;
        /**
         * 特殊票种类型
         */
        protected String SpecialInvoiceType;
        /**
         * 原发票代码
         */
        protected String OriginInvoiceCode;
        /**
         * 原发票号码
         */
        protected String OriginInvoiceNum;
        /**
         * 原发票月份
         */
        protected String OriginInvoiceMonth;
        /**
         * 专票冲红类型
         */
        protected String NegSpclInvType;
        /**
         * 专票红字通知单编号
         */
        protected String NegSpecialInvoicePermitNum;
        /**
         * 专票红字通知单提交盘号
         */
        protected String NegSpclInvPermitTaxDeviceSn;
        /**
         * 普票冲红原因
         */
        protected String NegOrdInvReason;
        /**
         * 商品分类版本号
         */
        protected String CatalogVer;
        /**
         * 开具时间
         */
        protected String InvoiceTime;
        /**
         * 校验码
         */
        protected String VerifyCode;
        /**
         * 发票密文
         */
        protected String Ciphertext;
        /**
         * 二维码
         */
        protected String QrCode;
        /**
         * 发票预览地址
         */
        protected String PreviewUrl;
        /**
         * OFD下载地址
         */
        protected String OfdFileUrl;
        /**
         * PDF下载地址
         */
        protected String PdfFileUrl;
        /**
         * 状态
         */
        protected String State;
        /**
         * 作废人
         */
        protected String InvalidateOperator;
        /**
         * 作废时间
         */
        protected String InvalidateTime;
        /**
         * 商品信息列表
         */
        protected List<InvoiceDataItem> ItemList;
    }

    @Getter
    @Setter
    @ToString
    @Accessors(chain = true)
    public static class InvoiceDataItem {
        /**
         * 商品名称
         */
        protected String ItemName;
        /**
         * 含税单价
         */
        protected String UnitPrice;
        /**
         * 单价(不含税)
         */
        protected String UnitPriceTaxExcluded;
        /**
         * 含税金额
         */
        protected String Amount;
        /**
         * 金额(不含税)
         */
        protected String AmountTaxExcluded;
        /**
         * 数量
         */
        protected String Quantity;
        /**
         * 税率
         */
        protected String TaxRate;
        /**
         * 税额
         */
        protected String Tax;
        /**
         * 规格型号
         */
        protected String Specifications;
        /**
         * 单位
         */
        protected String Unit;
        /**
         * 折扣金额（不含税）
         */
        protected String DiscountAmountTaxExcluded;
        /**
         * 含税折扣金额
         */
        protected String DiscountAmount;
        /**
         * 折扣税额
         */
        protected String DiscountTax;
        /**
         * 商品分类名称
         */
        protected String CatalogName;
        /**
         * 商品分类编码
         */
        protected String CatalogCode;
        /**
         * 优惠政策标识
         */
        protected String HasPreferentialPolicy;
        /**
         * 优惠政策类型
         */
        protected String PreferentialPolicy;
        /**
         * 免税类型
         */
        protected String TaxFreeType;
    }
}
