package com.icetech.partner.domain.model.kuangu;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
public class KuanGuResponse {
    /**
     * 处理结果代码 0表示成功，其他均表示失败，具体代码描述详见
     */
    protected String code;
    /**
     * 处理结果描述
     */
    protected String message;
    protected KuanGuHead head;
    protected String content;

    public static final String CODE_SUCCESS = "0";
    /**
     * 请求数据异常
     */
    public static final String CODE_FAILED_DATA_PREFIX = "10";
    /**
     * 时间戳检验、解码编码、签名信息异常
     */
    public static final String CODE_FAILED_SIGN_PREFIX = "19";
    /**
     * 接入应用异常
     */
    public static final String CODE_FAILED_APP_PREFIX = "20";
    /**
     * 服务接口异常
     */
    public static final String CODE_FAILED_API_PREFIX = "30";
    /**
     * 访问权限异常
     */
    public static final String CODE_FAILED_AUTH_PREFIX = "40";
    /**
     * 服务系统异常
     */
    public static final String CODE_FAILED_SERVER_PREFIX = "50";
    /**
     * 系统级异常
     */
    public static final String CODE_FAILED_SYSTEM_PREFIX = "9";
}
