package com.icetech.partner.domain.model.kuangu;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
public class KuanGuHead {
    /**
     * 接入应用ID，有服务提供方统一提供
     */
    protected String appid;
    /**
     * 接口代码
     */
    protected String serviceid;
    /**
     * 请求时间戳 使用String.valueOf(System.currentTimeMillis())获取
     */
    protected String timestamp;
    /**
     * 请求流水号，要保证同一个appid中保持唯一，32位
     */
    protected String noncestr;
    /**
     * 签名信息
     */
    protected String signature;
}
