package com.icetech.partner.domain.model.kuangu;

import java.util.List;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
public class GetInvoiceFileResponse {
    /**
     * 发票代码
     */
    protected String InvoiceCode;
    /**
     * 发票号码
     */
    protected String InvoiceNum;
    /**
     * 版式文件格式
     */
    protected String InvoiceFileFormat;
    /**
     * 版式文件大小
     */
    protected String InvoiceFileLength;
    /**
     * 版式文件内容
     */
    protected String InvoiceFileContent;
    /**
     * 图片列表
     */
    protected List<InvoiceImage> ImageList;

    @Getter
    @Setter
    @ToString
    @Accessors(chain = true)
    public static class InvoiceImage {
        /**
         * 图片文件格式
         */
        protected String ImageFileFormat;
        /**
         * 图片文件大小
         */
        protected String ImageFileLength;
        /**
         * 图片文件内容
         */
        protected String ImageFileContent;
    }
}
