package com.icetech.partner.api.response.rule;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * Description ChargeRuleListResponse
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @Date 2022/7/22 14:29
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ChargeRuleListResponse implements Serializable {

    @ApiModelProperty(value = "总记录数", required = true, example = "100", position = 1)
    private Long total;

    @ApiModelProperty(value = "总页数", required = true, example = "10", position = 2)
    private String totalPage;

    @ApiModelProperty(value = "返回数据结果", required = true, position = 3)
    private List<ChargeRuleListItem> rows;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class ChargeRuleListItem implements Serializable {

        @ApiModelProperty(value = "计费规则编号", required = true, example = "100003", position = 1)
        private String billtypecode;

        @ApiModelProperty(value = "计费规则名称", required = true, example = "tet001", position = 2)
        private String billtypename;

        @ApiModelProperty(value = "计费规则类型 1、通用自然天 2、白天夜间收费 3、24小时计费;", required = true, example = "1", position = 3)
        private Integer billtype;

        @ApiModelProperty(value = "是否默认计费规则，0：否，1：是，车辆计费时使用默认计费规则;", required = true, example = "1", position = 4)
        private Integer isDefault;

        @ApiModelProperty(value = "操作时间（unix时间戳）", required = true, example = "1515151223", position = 5)
        private Long operTime;
    }
}
