package com.icetech.partner.api.response.rule;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author wanggang
 * @create 2022-07-22 18:17
 */
@Data
@AllArgsConstructor
@Builder
@NoArgsConstructor
public class ChargeRuleBaseResponse<T> implements Serializable {
    @ApiModelProperty(value = "是否默认计费规则，0：否，1：是，车辆计费时使用默认计费规则；", required = true, example = "1", position = 1)
    private Integer isDefault;

    @ApiModelProperty(value = "计费规则编号 时间+随机数小于16位", required = true, example = "1015616116131361361", position = 2)
    private String billtypecode;

    @ApiModelProperty(value = "计费规则名称", required = true, example = "白天计费规则", position = 3)
    private String billtypename;

    @ApiModelProperty(value = "计费规则明细", required = true, example = "", position = 4)
    private T chargeRule;
}
