package com.icetech.partner.api.response.open.teld;

import com.icetech.partner.api.request.open.teld.TeldBaseBean;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

@Getter
@Setter
@ToString
@NoArgsConstructor
@AllArgsConstructor
public class TeldBaseResponse extends TeldBaseBean {
    /**
     * 请求成功
     */
    public static final int SUCCESS = 0;
    /**
     * 系统错误
     */
    public static final int ERROR_SYSTEM = 500;
    /**
     * 签名错误
     */
    public static final int ERROR_SIGN = 4001;
    /**
     * Token错误
     */
    public static final int ERROR_TOKEN = 4002;
    /**
     * POST参数不合法
     */
    public static final int ERROR_STRUCT = 4003;
    /**
     * 请求的业务参数不合法
     */
    public static final int ERROR_PARAM_DATA = 4004;
    /**
     * 返回值为空
     */
    public static final int ERROR_NULL_RESPONSE = 4005;
    /**
     * 系统繁忙，此时请求方稍后重试
     */
    public static final int ERROR_SYSTEM_BUSY = -1;

    /**
     * 返回值
     * <dl>
     *     <dt>返回值: </dt>
     *     <dd>-1: 系统繁忙，此时请求方稍后重试</dd>
     *     <dd>0: 请求成功</dd>
     *     <dd>4001: 签名错误</dd>
     *     <dd>4002: Token错误</dd>
     *     <dd>4003: POST参数不合法,缺少必须的. 示例：OperatorID,Data,TimeStamp，Seq,Sig五个参数</dd>
     *     <dd>4004: 请求的业务参数不合法，各接口定义自己的必须参数</dd>
     *     <dd>4005: 返回值为空</dd>
     *     <dd>500: 系统错误</dd>
     * </dl>
     */
    protected Integer ret;
    /**
     * 返回信息
     */
    protected String msg;
    /**
     * 参数内容
     */
    protected String data;

    @Override
    public String buildSignContent() {
        return getRet() + getMsg() + getData();
    }

    public boolean isSuccess() {
        return SUCCESS == ret;
    }

    public static TeldBaseResponse success() {
        return success(null);
    }

    public static TeldBaseResponse success(String data) {
        return new TeldBaseResponse(SUCCESS, "", data);
    }

    public static TeldBaseResponse failed(int ret) {
        return new TeldBaseResponse(ret, "", "");
    }

    public static TeldBaseResponse failed(int ret, String msg) {
        return new TeldBaseResponse(ret, msg, "");
    }
}
