package com.icetech.partner.api.response.open.teld;

import java.io.Serializable;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

@Getter
@Setter
@ToString
public class QueryTokenRespData implements Serializable {
    public static final int SUCC_STAT_SUCCESS = 0;
    public static final int SUCC_STAT_FAILED = 1;
    public static final int FAIL_REASON_NONE = 0;
    public static final int FAIL_REASON_NOT_FOUND = 1;
    public static final int FAIL_REASON_SECRET_ERROR = 2;

    /**
     * 运营商标识: 调用方组织机构代码
     */
    protected String operatorID;
    /**
     * 成功状态: 0:成功；1:失败
     */
    protected Integer succStat;
    /**
     * 获取的凭证: 全局唯一凭证
     */
    protected String accessToken;
    /**
     * 凭证有效期: 凭证有效期，单位秒
     */
    protected Integer tokenAvailableTime;
    /**
     * 失败原因: 0:无；1:无此运营商；2:密钥错误；3～99:自定义
     */
    protected Integer failReason;
}
