package com.icetech.partner.api.response.base;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * Description BaseParkConfigResponse
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2022/7/14 10:01
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class BaseParkConfigResponse implements Serializable {

    @ApiModelProperty(value = "剩余多少空车位时，禁止入场", example = "0", required = true, position = 1)
    private Integer fullEmptynum;

    @ApiModelProperty(value = "在车位满的情况下，是否禁止临时车入内，0：否 1：是， 默认为0", example = "0", required = true, position = 2)
    private Integer isFullForbidenter;

    @ApiModelProperty(value = "在车位满的情况下，是否禁止月卡车入内", example = "1", required = true, position = 3)
    private Integer isFullForbidmonthenter;

    @ApiModelProperty(value = "在车位满的情况下，是否禁止VIP车入内，0：否 1：是", example = "0", required = true, position = 4)
    private Integer isFullForbidvipenter;

    @ApiModelProperty(value = "在车位满的情况下，是否禁止预约车入内，0：否 1：是", example = "0", required = true, position = 5)
    private Integer isFullForbidreserventer;

    @ApiModelProperty(value = "在车位满的情况下，是否禁止储值车入内，0：否 1：是", example = "0", required = true, position = 6)
    private Integer  isFullForbidstoreenter;

    @ApiModelProperty(value = "月卡车是否计入总车位数1是 2 否 默认是2", example = "2", required = true, position = 7)
    private Integer isCardcount;

    @ApiModelProperty(value = "车辆出入口停留多长时间监控坐席提醒", example = "0", required = true, position = 8)
    private Integer carenexTimelong;

    @ApiModelProperty(value = "出场到入场最小时间值，以秒为单位，默认值是0，如果车辆入场时上次出场时间至当前时间时间差小于x秒入场不进行任何处理", example = "0", required = false, position =9)
    private Integer enexMinTime;

    @ApiModelProperty(value = "车场状态:1启用;0禁用", example = "0", required = true, position =10)
    private Integer exenMinTime;

    @ApiModelProperty(value = "显示终端类型，1：LED，2：LCD", example = "1", required = false, position =11)
    private Integer displayTerminal;

    @ApiModelProperty(value = "控制卡型号 18：方控 19：科发 27：瑞泰科", example = "18", required = false, position =12)
    private Integer ledcardType;

    @ApiModelProperty(value = "是否有TTS 0无,1有", example = "0", required = false, position =13)
    private Integer ttsType;

    @ApiModelProperty(value = "计费精度 0：分钟，1：秒 默认0", example = "0", required = false, position =14)
    private Integer billPrecision;

    @ApiModelProperty(value = "军警车是否免费停车 0：不免费 1：免费 默认1", example = "0", required = false, position =15)
    private Integer isfreeSpecialcar;

    @ApiModelProperty(value = "AB车场内切换X时间不收费，单位分钟", example = "0", required = false, position =16)
    private Integer switchTm;

    @ApiModelProperty(value = "支持多车位管理超时处理规则1：B车计费结束时间按A车出场时间收费 ，2：B车计费结束时间按B车出场时间收费 默认为1", example = "1", required = false, position =17)
    private Integer switchType;

    @ApiModelProperty(value = "免费时间内是否自动抬杆 0：不自动 1：自动 默认为1", example = "1", required = false, position =18)
    private Integer isreleaseFreetm;

    @ApiModelProperty(value = "免费时长是否计入停车费用1：是 2：否 默认为2", example = "2", required = false, position =19)
    private Integer freetimeStatus;

    @ApiModelProperty(value = "是否补时 1是2否 默认为1", example = "1", required = false, position =20)
    private Integer is_filltime;

    @ApiModelProperty(value = "超时计费起始时间1末次缴费时间 2车辆入场时间 默认为1", example = "1", required = false, position =21)
    private Integer overtimeBillType;

    @ApiModelProperty(value = "是否允许二次使用免费时长 1不允许2允许 默认为1", example = "1", required = false, position =22)
    private Integer isallowfreetmonce;

    @ApiModelProperty(value = "收费是否抹零头1是2否 默认为1", example = "1", required = false, position =23)
    private Integer isnotgetsmallchange;

    @ApiModelProperty(value = "小型车无入场记录时的固定费用（单位元）", example = "0", required = false, position =24)
    private Integer fixedfeevalue;

    @ApiModelProperty(value = "大型车无入场记录时的固定费用（单位元）", example = "0", required = false, position =25)
    private Integer fixedFeeValueBig;

    @ApiModelProperty(value = "是否允许无牌车重复入场，0：否 1：是， 默认为0", example = "0", required = false, position =26)
    private Integer isNoplateRepeatenter;

}
