package com.icetech.partner.api.response;

import lombok.Data;

import java.io.Serializable;

/**
 * 云纵拉取费用返回
 */
@Data
public class YzQueryFeeResponse implements Serializable {

    /**
     * 车牌号
     */
    private String plate_no;
    /**
     * 商户订单号(对应系统中的orderNum)
     */
    private String out_order_id;
    /**
     * 云纵停车订单号
     */
    private String parking_order_no;
    /**
     * 停车场ID
     */
    private String parking_id;
    /**
     * 停车时长(分钟)
     */
    private Long charging_time;
    /**
     * 入场时间
     */
    private String start_time;
    /**
     * 应收总金额
     */
    private Integer total_amount;
    /**
     * 时长券每小时可抵扣的金额，单位为分
     */
    private Integer duration_coupon_price;
    /**
     * 是否隐藏入场时间、停车时长信息，默认为2
     * 1-隐藏，2-不隐藏
     */
    private String hidden_park_info;
}
