package com.icetech.partner.api.response;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author wanggang
 * @create 2023-06-05 9:53
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class HaiDaQingDaoUploadCheckRecordResponse implements Serializable {

    /**
     * 对账标志，参见数据字典
     * 0 ：全一致；1 ：入场记录数不一致；2 ：离场记录数不一致；3 ：入场、
     * 离场记录数都不一致；4 ：账单记录总金额或笔数不一致；5 ：入场记录
     * 数不一致，账单记录总金额或笔数不一致；6 ：离场记录数不一致，账
     * 单记录总金额或笔数不一致；7 ：全不一致
     */
    private Integer accountMark;

    /**
     * 图片对账标志
     * 0- 一致；1- 不一致
     */
    private Integer photoMark;

    /**
     * 操作返回码
     */
    private String resultCode;

    /**
     * 操作返回信息
     */
    private String msg;

}
