package com.icetech.partner.api.request.open.teld;

import java.io.Serializable;
import java.util.Date;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

@Getter
@Setter
@ToString
public class NotificationReqData implements Serializable {
    public static final String DATE_PATTERN = "yyyy-MM-dd HH:mm:ss";

    /**
     * <p>充电订单号</p>
     * <p>充电运营商订单号，即停车票编号，特来电的格式：8位日期+10位序列号</p>
     * <p>必填: 是</p>
     * <p>长度: 27</p>
     */
    protected String startChargeSeq;
    /**
     * <p>电站编号</p>
     * <p>充电运营商定义的电站唯一编码</p>
     * <p>必填: 是</p>
     * <p>长度: 20</p>
     */
    protected String stationID;
    /**
     * <p>电站名称</p>
     * <p>充电站名称的描述</p>
     * <p>必填: 是</p>
     * <p>长度: 50</p>
     */
    protected String stationName;
    /**
     * <p>停车场编号</p>
     * <p>停车场平台下的唯一编码</p>
     * <p>必填: 否</p>
     * <p>长度: 30</p>
     */
    protected String parkID;
    /**
     * <p>充电设备接口编码</p>
     * <p>充电运营商充电设备接口的编码</p>
     * <p>必填: 是</p>
     * <p>长度: 23</p>
     */
    protected String connectorID;
    /**
     * <p>充电设备接口名称</p>
     * <p>充电设备的名称，同一场站下唯一，如“301号交流”</p>
     * <p>必填: 是</p>
     * <p>长度: 20</p>
     */
    protected String connectorName;
    /**
     * <p>车牌号</p>
     * <p>必填项，需兼容新能源车牌号</p>
     * <p>必填: 是</p>
     * <p>长度: 10</p>
     */
    protected String plateNum;
    /**
     * <p>车位号</p>
     * <p>车位号</p>
     * <p>必填: 否</p>
     * <p>长度: 10</p>
     */
    protected String parkNo;
    /**
     * <p>开始充电时间</p>
     * <p>格式“yyyy-MM-dd HH:mm:ss”</p>
     * <p>必填: 是</p>
     * <p>长度:  </p>
     */
    protected Date startTime;
    /**
     * <p>结束充电时间</p>
     * <p>格式“yyyy-MM-dd HH:mm:ss”，充电结束之前为空</p>
     * <p>必填: 否</p>
     * <p>长度:  </p>
     */
    protected Date endTime;
    /**
     * <p>充电量</p>
     * <p>单位：度，小数点后2位，充电结束之前为空</p>
     * <p>必填: 否</p>
     * <p>长度:  </p>
     */
    protected Double power;
    /**
     * <p>电费</p>
     * <p>单位：元，小数点后2位，充电结束之前为空</p>
     * <p>必填: 否</p>
     * <p>长度:  </p>
     */
    protected Double elecMoney;
    /**
     * <p>服务费</p>
     * <p>单位：元，小数点后2位，充电结束之前为空</p>
     * <p>必填: 否</p>
     * <p>长度:  </p>
     */
    protected Double seviceMoney;
    /**
     * <p>总金额</p>
     * <p>单位：元，小数点后2位，充电结束之前为空</p>
     * <p>必填: 否</p>
     * <p>长度:  </p>
     */
    protected Double totalMoney;
    /**
     * <p>停车减免方式</p>
     * <p>减免停车费的计算方式：1：根据时长减免、2：根据费用减免、3：停车场决定</p>
     * <p>必填: 是</p>
     * <p>长度: 1</p>
     */
    protected Integer calculationMethod;
    /**
     * <p>停车减免时长</p>
     * <p>单位：分钟</p>
     * <p>必填: 否</p>
     * <p>长度:  </p>
     */
    protected Integer freeParkingTimes;
    /**
     * <p>停车减免费用</p>
     * <p>单位：元</p>
     * <p>必填: 否</p>
     * <p>长度:  </p>
     */
    protected Double freeParkingCost;
}
