package com.icetech.partner.api.request.open.teld;

import java.io.Serializable;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

@Getter
@Setter
@ToString
public class AuthResultReqData implements Serializable {
    /**
     * <p>充电订单号</p>
     * <p>充电运营商订单号，特来电的格式：8位日期+10位序列号，用来识别停车票订单</p>
     * <p>必填: 是</p>
     * <p>长度: </p>
     */
    protected String StartChargeSeq;
    /**
     * <p>电站编号</p>
     * <p>充电运营商定义的电站唯一编码（停车场编号和电站编号必须填写一项）</p>
     * <p>必填: 否</p>
     * <p>长度: </p>
     */
    protected String StationID;
    /**
     * <p>停车场编号</p>
     * <p>充电运营商定义的电站唯一编码（停车场编号和电站编号必须填写一项）</p>
     * <p>必填: 否</p>
     * <p>长度: </p>
     */
    protected String ParkID;
    /**
     * <p>车牌号</p>
     * <p></p>
     * <p>必填: 是</p>
     * <p>长度: </p>
     */
    protected String PlateNum;
    /**
     * <p>车牌鉴权结果</p>
     * <p>0：未鉴权、1：鉴权通过、2：鉴权不通过</p>
     * <p>必填: 是</p>
     * <p>长度: </p>
     */
    protected Integer PlateAutResult;
    /**
     * <p>鉴权失败原因</p>
     * <dl>
     *     <dt>鉴权失败原因，返回如下错误码：</dt>
     *     <dd>0:无（鉴权通过或未鉴权）</dd>
     *     <dd>1:车辆不在停车场</dd>
     *     <dd>2:无该停车场权限</dd>
     *     <dd>3:停车场标识不正确</dd>
     *     <dd>4:优惠券已下发，请勿重复下发</dd>
     *     <dd>5:优惠券生成失败</dd>
     *     <dd>6:优惠券已用完</dd>
     *     <dd>7:参数异常</dd>
     *     <dd>8:请勿在短时间内频繁操作</dd>
     *     <dd>9:服务器内部异常</dd>
     *     <dd>10:未知</dd>
     * </dl>
     * <p>必填: 是</p>
     * <p>长度: </p>
     */
    protected Integer PlateAutFailReason;
}
