package com.icetech.partner.api.request.open.response;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 三方计费返回参数
 * @author fangct
 */
@Data
public class ThirdFeeResponse implements Serializable {

    @ApiModelProperty(value = "错误码，200 成功", example = "200", required = true, position = 1)
    protected String code;

    @ApiModelProperty(value = "错误信息", example = "系统异常", position = 2)
    protected String msg;

    @ApiModelProperty(value = "计费数据", example = "", position = 3)
    private ThirdFeeResponseData data;
    
    @Data
    public static class ThirdFeeResponseData implements Serializable {
        /**
         * 订单号
         */
        @NotBlank(message = "订单号不能为空")
        @ApiModelProperty(value = "订单号", example = "2022072688888", required = true, position = 1)
        private String orderNum;

        /**
         * 车牌号
         */
        @NotBlank(message = "车牌号不能为空")
        @ApiModelProperty(value = "车牌号", example = "京A88888", required = true, position = 2)
        private String plateNum;

        /**
         * 通道编号
         */
        @NotBlank(message = "通道编号不能为空")
        @ApiModelProperty(value = "通道编号", example = "C22072688888", required = true, position = 3)
        private String channelCode;

        /**
         * 是否需要支付费用（ 1是  0否）
         */
        @NotNull(message = "是否需要支付费用不能为空")
        @ApiModelProperty(value = "是否需要支付费用（0 否 1 是）", example = "10.0", required = true, position = 4)
        private String isNeedPay;

        /**
         * 总应收 本车辆从入场到当前时刻的总费用
         */
        @NotBlank(message = "总应收不能为空")
        @ApiModelProperty(value = "总应收，单位元", example = "10.0", required = true, position = 5)
        private String totalPrice;

        /**
         * 总优惠
         */
        @NotBlank(message = "优惠金额不能为空")
        @ApiModelProperty(value = "优惠金额，单位元", example = "2.0", required = true, position = 6)
        private String discountPrice;

        /**
         * 需支付金额
         */
        @NotBlank(message = "需支付金额不能为空")
        @ApiModelProperty(value = "需支付金额，单位元", example = "8.0", required = true, position = 7)
        private String needPayPrice;
    }
}
