package com.icetech.partner.api.request.open.base;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * Description ParkSeniorInfoRequest
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @Date 2022/7/14 09:45
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ParkSeniorInfoRequest implements Serializable {

    @NotBlank(message = "停车场编号不能为空")
    @ApiModelProperty(value = "停车场编号（系统自动生成）", example = "P100122", required = true, position = 1)
    private String parkCode;

}
