package com.icetech.partner.api.request.open.base;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * Description DelRegionRequest
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2022/7/18 14:09
 */
@Data
public class DelRegionRequest implements Serializable {

    @NotBlank(message = "停车场编号不能为空")
    @ApiModelProperty(value = "停车场编号", required = true, example = "P1000001", position = 2)
    private String parkCode;

    @NotBlank(message = "分区编号不能为空")
    @ApiModelProperty(value = "分区编号（长度6-32位，全平台唯一）", required = true, example = "100003", position = 1)
    private String regionCode;
    
}
