package com.icetech.partner.api.request.open;

import com.icetech.common.annotation.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author wanggang
 * @create 2021-08-27 10:46
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ScanPayRequestDTO implements Serializable {

    /**
     * 设备序列号
     */
    @NotNull
    private String sn;

    /**
     * 付款码
     */
    @NotNull
    private String payCode;

    /**
     * 反扫支付时间戳，单位秒
     */
    @NotNull
    private Long payTime;
}
