package com.icetech.partner.api.request.open;

import java.util.List;

import com.icetech.basics.domain.entity.device.ParkDevice;
import lombok.Data;
import com.icetech.common.annotation.NotNull;

/**
 * @author zhangpengzhan
 * @date 2021/6/7 17:48
 * @description:
 */
@Data
public class ParkInoutdeviceCheckRequest {
    private Long id;
    private Long parkId;
    private String inandoutCode;
    @NotNull
    private String inandoutName;
    @NotNull
    private Integer inandoutType;
    private Integer status;
    private String createTime;
    private String adder;
    private String updateTime;
    private String updateUser;

    /**
     * 端云架构新增
     */
    private Integer isAllowTempcarrun;
    private Integer isAllowNocardrun;
    private Integer isAllowYellowcarrun;
    private Integer isOpenVaguetype;
    private Integer vaguetype;
    private Integer isOpenQrcodetype;
    private Integer cacheExpires;

    private String thirdInandoutCode;
    /**
     * 端网云架构新增
     */
    private Integer isAllowNewenergycarrun;
    private Integer isAllowVisitCar;
    private Integer isAllowMonthCar;
    private Integer isOverTimeMonth;
    private Integer overTimeDay;
    private Integer overTimeMonthlyCard;
    private Integer isAllowBackCar;
    @NotNull
    private Integer isMaster;
    private String regionCode;
    private Integer isCharge;
    private Integer isAllowOvertimeCar;
    private Integer isAllowAbcar;
    private Integer isAllowVipCar;
    private String vipCarTypeId;
    private Integer isAllowBluerun;
    private Integer isAllowStoredCar;

    /**
     * 车场通道编辑设备列表
     *
     */
    private List<ParkDevice> devices;
    @NotNull
    private String parkCode;


    private ParkDevice mainCamera;
    private ParkDevice secoCamera;
    private ParkDevice robotDev;
    private ParkDevice voiceDev;
    private ParkDevice monitorDev;
    private ParkDevice intercomPillarDev;

}
