package com.icetech.partner.api.request.open;

import com.icetech.common.annotation.NotNull;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author wanggang
 * @create 2021-07-28 9:48
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class ModifyFeeRequestDTO implements Serializable {

    /**
     * 停车场编号
     */
    @NotNull
    @NotBlank(message = "停车场编号不能为空")
    @ApiModelProperty(value = "停车场编号", required = true, example = "P100000", position = 1)
    private String parkCode;

    /**
     * 当前车辆所在的出口通道编号
     */
    @ApiModelProperty(value = "当前车辆所在的出口通道编号", example = "C100000", position = 2)
    private String channelCode;

    /**
     * 订单号，确保订单号在此车场内的唯一性
     */
    @NotNull
    @NotBlank(message = "订单号不能为空")
    @ApiModelProperty(value = "订单号，确保订单号在此车场内的唯一性", required = true, example = "D100000", position = 3)
    private String orderNum;

    /**
     * 车牌号
     */
    @ApiModelProperty(value = "车牌号", example = "京A88888", position = 4)
    private String plateNum;

    /**
     * 应支付金额，保留两位小数
     */
    @NotNull
    @NotBlank(message = "应支付金额不能为空")
    @ApiModelProperty(value = "应支付金额，保留两位小数", required = true, example = "100.00", position = 5)
    private String unpayPrice;

    /**
     * 修改后的支付金额，保留两位小数
     */
    @NotNull
    @NotBlank(message = "修改后的支付金额不能为空")
    @ApiModelProperty(value = "修改后的支付金额，保留两位小数", required = true, example = "90.00", position = 6)
    private String newPrice;


}
