package com.icetech.partner.api;

import com.icetech.cloudcenter.domain.response.InvoiceDetailResponse;
import com.icetech.cloudcenter.domain.response.InvoiceRecordResponse;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.open.domain.request.invoice.AuthorizeRequest;
import com.icetech.open.domain.request.invoice.BlueInvoiceRequest;
import com.icetech.open.domain.request.invoice.InvoicePageRequest;
import com.icetech.open.domain.request.invoice.SearchMerchantRequest;
import com.icetech.open.domain.response.invoice.InvoicePaperInfoResponse;
import com.icetech.open.domain.response.invoice.SearchMerchantResponse;

import java.util.List;

/**
 * 开发票功能
 * @author fangct
 */
public interface InvoiceApi {

    /**
     * 开蓝票
     * @param blueInvoiceRequest
     * @return 返回开票同步结果
     */
    ObjectResponse blueInvoice(BlueInvoiceRequest blueInvoiceRequest) ;

    /**
     * 获取开票结果，
     * @param orderId 开票平台的唯一编号并发送邮件
     * @return 返回处理成功或失败
     */
    ObjectResponse getBlueResult(String orderId);

    /**
     * 显示发票地址
     * @param orderId
     * @return 发票的图片URL和PDF的URL地址
     */
    ObjectResponse<InvoicePaperInfoResponse> showInvoice(String orderId);

    /**
     * 抬头模糊搜索
     * @param searchMerchantRequest
     * @return 返回抬头的全名和税号的结果集
     */
    ObjectResponse<List<SearchMerchantResponse>> searchMerchant(SearchMerchantRequest searchMerchantRequest) ;

    /**
     * 验证是否重复开票
     * @param tradeNo
     * @return
     */
    ObjectResponse validateRepeate(String tradeNo);

    /**
     * 获取授权链接
     */
    ObjectResponse<String> authorize(AuthorizeRequest params);

    /**
     * 获取公众号用户的发票记录
     */
    ObjectResponse<List<InvoiceRecordResponse>> getInvoiceRecords(Integer mpUserId, InvoicePageRequest basePageRequest);

    /**
     * 根据订单号获取开票详情
     */
    ObjectResponse<InvoiceDetailResponse> getInvoiceDetail(String orderId);

    /**
     * 定时查询阿里的发票状态
     */
    ObjectResponse updateAliInvoice();

    /**
     * 查询已开发票的tradeNo
     * @param plateNum
     * @param plateNumList
     * @return
     */
    ObjectResponse<List<String>> getCheckedTradeNoList( String plateNum, List<String> plateNumList);


}
