package com.icetech.partner.api;

import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.partner.domain.request.BstAdBidRequest;
import com.icetech.partner.domain.response.AdviceResponse;
import com.icetech.partner.domain.response.BstAdBidResponse;

public interface IAdviceService {
    ObjectResponse<AdviceResponse> getAdVert(String parkCode,String userIp, String userAgent, Integer type);

    /**
     * Description: 获取博思特广告
     * Version1.0 2023-06-14 by wgy 创建
     *
     * @param parkCode          车场编号
     * @param deviceType        设备类型 0：公众号；1：小程序； 2：APP；3：缴费机 4：补交机 ；5;电视机；6：支付宝；9;通用设备
     * @param triggerEvent      触发事件
     * @param bstAdBidRequest   请求参数
     * @return com.icetech.common.domain.response.ObjectResponse<com.icetech.partner.domain.response.BstAdBidResponse>
     */
    ObjectResponse<BstAdBidResponse> getBstAd(String parkCode, Integer deviceType, Integer triggerEvent, BstAdBidRequest bstAdBidRequest);

    /**
     * 获取跳转Url
     * @return
     */
    ObjectResponse<AdviceResponse> getJumpUrl(String userAgent);

    /**
     * 获取口令信息
     * @return
     */
    ObjectResponse<String> getKl();
}
