/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.partner.domain.request.wuxi;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.icetech.partner.domain.request.wuxi.BaseDataItem;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.time.DateFormatUtils;

public class WuXiRequest {
    protected String pno;
    protected String tn;
    protected String ts;
    protected String ve;
    protected String dataItems;
    protected String file;
    public static final String TS_DATE_PATTERN = "yyyyMMddHHmmssSSS";

    public WuXiRequest(String pno, String tn, BaseDataItem dataItem, String file) {
        this.pno = pno;
        this.tn = tn;
        this.ts = DateFormatUtils.format((Date)new Date(), (String)TS_DATE_PATTERN);
        this.dataItems = JSONObject.toJSONString((Object)dataItem);
        this.file = file;
    }

    public WuXiRequest(String pno, String tn, List<BaseDataItem> dataItems) {
        this.pno = pno;
        this.tn = tn;
        this.ts = DateFormatUtils.format((Date)new Date(), (String)TS_DATE_PATTERN);
        this.dataItems = JSONArray.toJSONString(dataItems);
    }

    public String getPno() {
        return this.pno;
    }

    public String getTn() {
        return this.tn;
    }

    public String getTs() {
        return this.ts;
    }

    public String getVe() {
        return this.ve;
    }

    public String getDataItems() {
        return this.dataItems;
    }

    public String getFile() {
        return this.file;
    }

    public void setPno(String pno) {
        this.pno = pno;
    }

    public void setTn(String tn) {
        this.tn = tn;
    }

    public void setTs(String ts) {
        this.ts = ts;
    }

    public void setVe(String ve) {
        this.ve = ve;
    }

    public void setDataItems(String dataItems) {
        this.dataItems = dataItems;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WuXiRequest)) {
            return false;
        }
        WuXiRequest other = (WuXiRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$pno = this.getPno();
        String other$pno = other.getPno();
        if (this$pno == null ? other$pno != null : !this$pno.equals(other$pno)) {
            return false;
        }
        String this$tn = this.getTn();
        String other$tn = other.getTn();
        if (this$tn == null ? other$tn != null : !this$tn.equals(other$tn)) {
            return false;
        }
        String this$ts = this.getTs();
        String other$ts = other.getTs();
        if (this$ts == null ? other$ts != null : !this$ts.equals(other$ts)) {
            return false;
        }
        String this$ve = this.getVe();
        String other$ve = other.getVe();
        if (this$ve == null ? other$ve != null : !this$ve.equals(other$ve)) {
            return false;
        }
        String this$dataItems = this.getDataItems();
        String other$dataItems = other.getDataItems();
        if (this$dataItems == null ? other$dataItems != null : !this$dataItems.equals(other$dataItems)) {
            return false;
        }
        String this$file = this.getFile();
        String other$file = other.getFile();
        return !(this$file == null ? other$file != null : !this$file.equals(other$file));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WuXiRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $pno = this.getPno();
        result = result * 59 + ($pno == null ? 43 : $pno.hashCode());
        String $tn = this.getTn();
        result = result * 59 + ($tn == null ? 43 : $tn.hashCode());
        String $ts = this.getTs();
        result = result * 59 + ($ts == null ? 43 : $ts.hashCode());
        String $ve = this.getVe();
        result = result * 59 + ($ve == null ? 43 : $ve.hashCode());
        String $dataItems = this.getDataItems();
        result = result * 59 + ($dataItems == null ? 43 : $dataItems.hashCode());
        String $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : $file.hashCode());
        return result;
    }

    public String toString() {
        return "WuXiRequest(pno=" + this.getPno() + ", tn=" + this.getTn() + ", ts=" + this.getTs() + ", ve=" + this.getVe() + ", dataItems=" + this.getDataItems() + ", file=" + this.getFile() + ")";
    }
}

