package com.icetech.partner.domain.response.wuxiqu;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author wanggang
 * @create 2023-12-11 9:36
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class WuXiQuPayResultResponse implements Serializable {

    /**
     * 操作返回码
     */
    private Integer resultCode;

    /**
     * 操作返回信息
     */
    private String msg;
    /**
     * 车牌号
     */
    private String plateNo;

    /**
     * 停车场账单编号
     */
    private String billId;
    /**
     * 账单生成时间
     */
    private String billTime;

    /**
     * 实付金额
     * (单位分)
     */
    private Integer actualPay;

    /**
     * 账单支付完成状态0-未完成1-已完成
     */
    private Integer payStatus;

    /**
     * 交易金额
     */
    private Integer transAmount;

    /**
     * 优惠金额
     */
    private Integer discountAmount;

    /**
     * 交易时间
     */
    private String dealTime;

    /**
     * 第三方支付渠道流水号
     */
    private String orderCode;

    /**
     * 付费方式
     */
    private Integer paidType;

    /**
     * 付费场景
     */
    private Integer payType;
}
