package com.icetech.partner.domain.response.luogang;

import java.io.Serializable;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class Response<T> implements Serializable {
    protected Boolean flag;
    protected Integer code;
    protected String msg;
    protected T data;

    public static final TypeReference<Response<Void>> RESP_TYPE_VOID = new TypeReference<Response<Void>>() {
    };
    public static final TypeReference<Response<JSONObject>> RESP_TYPE_GET_TOKEN = new TypeReference<Response<JSONObject>>() {
    };

    public static final Integer CODE_SUCCESS = 1;
    public static final Integer CODE_FAILED = -1;

    public static boolean isSuccess(Response<?> response) {
        return response != null && (Boolean.TRUE.equals(response.getFlag()) || CODE_SUCCESS.equals(response.getCode()));
    }

    public static <T> Response<T> failed(String msg) {
        return failed(CODE_FAILED, msg);
    }

    public static <T> Response<T> failed(int code, String msg) {
        return new Response<>(false, code, msg, null);
    }

    public static <T> Response<T> success() {
        return success(null);
    }

    public static <T> Response<T> success(T data) {
        return new Response<>(true, CODE_SUCCESS, null, data);
    }
    public static <T> Response<T> getInstance(int code, String msg) {
        return new Response<>(CODE_SUCCESS == code ? true : false, code, msg, null);
    }
}
