package com.icetech.partner.domain.response;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;

@Setter
@Getter
@ToString
public class QueryEnterRecordResponse implements Serializable {
    @ApiModelProperty(value = "停车场编号", required = true, example = "P100000", position = 1)
    private String parkCode;

    @ApiModelProperty(value = "停车场名称", required = true, example = "北辰停车场", position = 2)
    private String parkName;

    @ApiModelProperty(value = "订单号，确保订单号在此车场内的唯一性", required = true, example = "1000000220020", position = 3)
    private String orderNum;

    @ApiModelProperty(value = "车牌号", required = true, example = "京A88888", position = 4)
    private String plateNum;

    @ApiModelProperty(value = "入口名称", required = true, example = "北入口", position = 5)
    private String channelName;

    @ApiModelProperty(value = "车辆类型，详情查看数据定义部分", required = true, example = "2", position = 6)
    private Integer type;

    @ApiModelProperty(value = "车型，详情查看数据定义部分", required = true, example = "22", position = 7)
    private Integer carType;

    @ApiModelProperty(value = "入场图片URL，注意：url有效期为30分钟", example = "", position = 8)
    private String imgUrl;

    @ApiModelProperty(value = "无入场记录标识，0：否，1：是", example = "1", position = 9)
    private Integer noneEnterFlag = 0;

    @ApiModelProperty(value = "车牌颜色", example = "蓝色", position = 10)
    private String plateColor;

    @ApiModelProperty(value = "进场时间（unix时间戳 10位）", example = "1657614044", position = 11)
    private Long enterTime;
    /**
     * 入场方式：1车牌识别入场，2遥控器抬杆入场，3无牌车扫码入场，4软件人工入场
     */
    @ApiModelProperty(value = "入场方式：1车牌识别入场，2遥控器抬杆入场，3无牌车扫码入场，4软件人工入场", example = "1", position = 12)
    private Integer enterWay;

}
