package com.icetech.partner.domain.request.zhuhai;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author wanggang
 * @create 2023-10-09 14:11
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ZhuHaiRequest implements Serializable {

    /**
     * 停车场基本信息
     */
    private ParkInfo parkInfo;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class ParkInfo implements Serializable {

        /**
         * 三方车场编码
         */
        private String thirdParkCode;

        /**
         * 三方车场名称
         */
        private String thirdParkName;

    }
}
