package com.icetech.partner.domain.request.yongcheng;

import com.alibaba.fastjson2.TypeReference;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * 响应数据
 */
// (\w+)[ \t]+(\w+)[ \t]+(是|否)[ \t]+(.+)
// /** $4(必选: $3) */\nprotected $2 $1;
@Getter
@Setter
@ToString
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class YongChengResponse<T> implements Serializable {
    public static final Integer RESULT_SUCCESS = 0;
    public static final Integer RESULT_FAILED = 1;

    /** 是否成功。0 成功 1 失败(必选: 是) */
    protected Integer result;
    /** 错误代号(必选: 否) */
    protected Integer errorCode;
    /** 返回错误信息，如非空，为错误原因(必选: 否) */
    protected String errorMsg;
    /** 见接口说明(必选: 否) */
    protected T data;

    public static final TypeReference<YongChengResponse<Void>> TYPE_VOID = new TypeReference<YongChengResponse<Void>>() {
    };
    public static final TypeReference<YongChengResponse<YongChengAutoPayResponse>> PARK_PAY_RESP = new TypeReference<YongChengResponse<YongChengAutoPayResponse>>() {
    };
}
