package com.icetech.partner.domain.request.yongcheng;


import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * 请求参数
 */
// (\w+)[ \t]+(\w+)[ \t]+(是|否)[ \t]+(.+)
// /** $4(必选: $3) */\nprotected $2 $1;
@Getter
@Setter
@ToString
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
@Builder
public class YongChengRequest implements Serializable {
    /** 接入系统账号(必选: 是) */
    protected String accessName;
    /** 用私钥对请求参数加密(必选: 是) */
    protected String data;
    /** 用私钥对 data 的签名(必选: 是) */
    protected String sign;
}
