package com.icetech.partner.domain.request.yongcheng;

import lombok.AllArgsConstructor;
import lombok.Getter;

public interface YongChengConsts {
    String DATETIME_PATTERN = "yyyy-MM-dd HH:mm:ss";

    String BSS_TYPE_ENTER = "1";
    String BSS_TYPE_EXIT = "2";

    /** 01-大型汽车 */
    String PLATE_TYPE_BIG = "01";
    /** 02-小型汽车 */
    String PLATE_TYPE_SMALL = "02";
    /** 51-大型新能源车 */
    String PLATE_TYPE_BIG_GREEN = "51";
    /** 52-小型新能源车 */
    String PLATE_TYPE_SMALL_GREEN = "52";

    /** 0-未知 */
    String PLATE_COLOR_UNKNOWN = "0";
    /** 1-蓝 */
    String PLATE_COLOR_BLUE = "1";
    /** 2-黄 */
    String PLATE_COLOR_YELLOW = "2";
    /** 3-黑 */
    String PLATE_COLOR_BLACK = "3";
    /** 4-白 */
    String PLATE_COLOR_WHITE = "4";
    /** 5-绿 */
    String PLATE_COLOR_GREEN = "5";

    /** 11-普通到达 */
    String PARK_BSS_TYPE_NORMAL = "11";
    /** 12-包月到达 */
    String PARK_BSS_TYPE_MONTH = "12";
    /** 13-企业包月到达 */
    String PARK_BSS_TYPE_MONTH_COMPANY = "13";
    /** 14-产权车到达 */
    String PARK_BSS_TYPE_OWNER = "14";
    /** 15-特殊车辆到达 */
    String PARK_BSS_TYPE_SPECIAL = "15";
    /** 16-挂单车到达 */
    String PARK_BSS_TYPE_GUA_DAN = "16";

    /** 21-免费离开 */
    String LEAVE_BSS_TYPE_FREE = "21";
    /** 22-包月离开 */
    String LEAVE_BSS_TYPE_MONTH = "22";
    /** 23-设备异常免费 */
    String LEAVE_BSS_TYPE_DEVICE_ABNORMALITY = "23";
    /** 24-付费离开 */
    String LEAVE_BSS_TYPE_PAYMENT = "24";
    /** 25-欠费离开 */
    String LEAVE_BSS_TYPE_ARREARS = "25";
    /** 30-产权车离开 */
    String LEAVE_BSS_TYPE_OWNER = "30";
    /** 31-挂单车离开 */
    String LEAVE_BSS_TYPE_GUA_DAN = "31";

    String PAY_TYPE_AUTO = "1";
    String PAY_TYPE_MANUAL = "2";
    String PAY_TYPE_REFUND = "9";

    String PAY_STATUS_WAIT = "0";
    String PAY_STATUS_PAID = "1";

    @Getter
    @AllArgsConstructor
    enum PayMode {
        /** 1-余额 */
        BALANCE("1", "余额"),
        /** 2-微信 */
        WECHAT("2", "微信"),
        /** 3-支付宝 */
        ALIPAY("3", "支付宝"),
        /** 4-农行掌银 */
        ABC("4", "农行掌银"),
        /** 12-微信（农行通道） */
        WECHAT_ABC("12", "微信（农行通道）"),
        /** 13-支付宝（农行通道） */
        ALIPAY_ABC("13", "支付宝（农行通道）"),
        /** 15-支付宝免密 */
        ALIPAY_AUTO("15", "支付宝免密"),
        /** 16-微信免密 */
        WECHAT_AUTO("16", "微信免密"),
        /** 17-农行免密 */
        ABC_AUTO("17", "农行免密"),
        /** 18-云闪付免密 */
        UNIONPAY_AUTO("18", "云闪付免密"),
        /** 19-云闪付（农行通道） */
        UNIONPAY_ABC("19", "云闪付（农行通道）"),
        /** 20-云闪付支付（原生） */
        UNIONPAY("20", "云闪付支付（原生）"),
        /** 21-二三类卡电子钱包 */
        EWALLET("21", "二三类卡电子钱包"),
        /** 22-信用兜底 */
        CREDIT("22", "信用兜底"),
        /** 23-ETC 支付 */
        ETC("23", "ETC 支付"),
        OTHER("", "ETC 支付"),
        ;

        private final String code;
        private final String desc;

        public static PayMode parseCode(String code) {
            for (PayMode mode : PayMode.values()) {
                if (mode.code.equals(code)) return mode;
            }
            return OTHER;
        }
    }
}
