package com.icetech.partner.domain.request.yongcheng;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

import java.io.Serializable;

@Getter
@Setter
@ToString
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class YongChengAutoPayResponse implements Serializable {

    /**
     * 是否抬杆放行（0 否 1 是）
     * 本字段为 2.9.0 版本后新增字段，之前已对
     * 接的可以按照以前的方式进行判断，也可以
     * 按照该字段信息抬杆放行判定。
     * 具体见接口详细说明。
     */
    private String isPass;

    /**
     * 停车场支付订单号
     */
    private String outTradeNo;

    /**
     * 平台方支付 ID（该 ID 为支付的唯一 ID，用于判断支付记录是否重复发送，可用于退
     * 款）
     * 若 payStatus 字段为 0 时此字段为空
     * 若 payStatus 字段为 1，且 payMode 为免密
     * 支付则此字段为空
     * 若 isCreditleave 字段为 1 时此字段为空
     */
    private String payid;


    /**
     * 应交费总金额（单位：分）
     */
    private Integer paymentTotal;


    /**
     * 本次实付金额（单位：分）
     * 若 payStatus 字段为 1 时，停车场发起的本
     * 次交易金额=本次实付金额+本次优惠金额。
     * 若 payStatus 字段为 1，且 payMode 为免密
     * 支付则此字段为空
     * 若 isCreditleave 字段为 1 时此字段为空
     */
    private Integer actualPay;


    /**
     * 本次支付优惠金额（单位分）
     * 若 payStatus 字段为 1，且 payMode 为免密
     * 支付则此字段为空
     * 若 isCreditleave 字段为 1 时此字段为空
     */
    private Integer payPreferential;


    /**
     * 账单支付完成状态（0-未完成 1-已完成）
     */
    private String payStatus;


    /**
     * 支付方式（支付方式详见数据字典）
     * 当全额优惠的，此字段为“1”
     * 若 payStatus 字段为 0 时，此字段为空
     * 若 isCreditleave 字段为 1 时此字段为空
     */
    private String payMode;


    /**
     * 是否信用离场（0 否 1 是）
     */
    private String isCreditleave;


    /**
     * 是否共享停车（0 否 1 是）
     */
    private String isShare;

}
