package com.icetech.partner.domain.request.wuxi;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author wanggang
 * @create 2023-12-08 14:03
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class WuXiQuApplyPayRequest implements Serializable {

    /**
     * 停车场编号
     */
    private String parkCode;

    /**
     * 记录 ID
     */
    private String recordId;

    /**
     * 车牌号
     */
    private String plateNo;

    /**
     * 车牌颜色 (0:未知,1:蓝色,2:黄
     * 色,3:白色,4:黑色,5:绿色，6：黄绿车牌)
     */
    private Integer plateColor;

    /**
     * 进场时间
     * (yyyy-MM-dd
     * HH:mm:ss)
     */
    private String inTime;

    /**
     * 离开时间（格式：yyyy-MM- dd HH:mm:ss）
     */
    private String outTime;

    /**
     * 出口编号
     */
    private String exitCode;

    /**
     * 场库系统给出的账单编号
     */
    private String billId;

    /**
     * 账单生成时间
     * （格式：yyyy- MM-dd HH:mm:ss）
     */
    private String billTime;

    /**
     * 实付金额(单位分)
     */
    private Integer actualPay;

    /**
     * 账单支付完成状态0-未完成;1-已完成（申请扣款 时，默认0-未支付）
     */
    private Integer payStatus;

    /**
     * 车辆在场状态0：车辆在场 1：车辆已离场
     */
    private Integer carStock;
}
