package com.icetech.partner.domain.request.wuxi;

import lombok.Data;

/**
 * 车辆离开业务 业务参数
 *
 * @author FGD
 */
@Data
public class OutLogDataItem implements BaseDataItem {
    /**
     * <p>车牌</p>
     * <p>必填: 是</p>
     */
    protected String lpn;
    /**
     * <p>停车场编号</p>
     * <p>必填: 是</p>
     */
    protected String parkCode;
    /**
     * <p>入口编号</p>
     * <p>必填: 否</p>
     */
    protected String exitCode;
    /**
     * <p>离场时间</p>
     * <p>格式: yyyy-MM-dd HH:mm:ss</p>
     * <p>必填: 是</p>
     */
    protected String outTime;
    /**
     * <p>出场车辆照片URL</p>
     * <p>路径要求：停车场编号/yyyyMMdd/文件名</p>
     * <p>必填: 是</p>
     */
    protected String outPicName;
    /**
     * <p>离场类型（1：正常离场；2：免费放行；3：异常放行）</p>
     * <p>必填: 是</p>
     */
    protected Integer outType;
    /**
     * <p>记录ID</p>
     * <p>停车场业务编号（业务编号为一次车辆到达离开的业务ID）</p>
     * <p>为保证唯一性可以考虑parkId+recordId</p>
     * <p>必填: 是</p>
     */
    protected String recordId;
    /**
     * <p>应付金额</p>
     * <p>必填: 是</p>
     */
    protected Integer shouldPay;
    /**
     * <p>实付金额</p>
     * <p>必填: 是</p>
     */
    protected Integer actualPay;
    /**
     * <p>备注</p>
     * <p>必填: 否</p>
     */
    protected String remark;
    /**
     * <p>卡口id</p>
     * <p>必填: 是</p>
     */
    protected String tollgateID;
    /**
     * <p>出场编号</p>
     * <p>必填: 是</p>
     */
    protected String outChannel;
    /**
     * <p>摄像机id</p>
     * <p>必填: 是</p>
     */
    protected String cameraId;
    /**
     * <p>剩余车位数</p>
     * <p>必填: 是</p>
     */
    protected Integer freeCount;
}
