package com.icetech.partner.domain.request.wuxi;

import lombok.Data;

/**
 * 车辆到达业务 业务参数
 *
 * @author FGD
 */
@Data
public class InLogDataItem implements BaseDataItem {
    /**
     * <p>车牌</p>
     * <p>必填: 是</p>
     */
    protected String lpn;
    /**
     * <p>车牌颜色</p>
     * <p>0:未知; 1:蓝色; 2:黄色; 3:白色; 4:黑色; 5:绿色</p>
     * <p>必填: 是</p>
     */
    protected Integer plateColor;
    /**
     * <p>车牌类别</p>
     * <p>0:未知车牌,1:蓝牌小汽车,2:黑牌小汽车,3:单排黄牌,4:双排黄牌（大车尾牌、农用车）,
     * 5:警车车牌,6:武警车牌,7:个性化车牌,8:单排军车牌,9:双排军车牌,
     * 10:使馆车牌,11:香港进出中国大陆车牌,12: 农用车牌,13: 教练车牌,14: 澳门进出中国大陆车牌,
     * 15:双层武警车牌,16:武警总队车牌,17:双层武警总队车牌,18:民航,19:新能源</p>
     * <p>必填: 是</p>
     */
    protected Integer plateType;
    /**
     * <p>停车场编号(即：parkId)</p>
     * <p>必填: 是</p>
     */
    protected String parkCode;
    /**
     * <p>车型</p>
     * <p>必填: 否</p>
     */
    protected String carModel;
    /**
     * <p>入口编号</p>
     * <p>必填: 否</p>
     */
    protected String entryCode;
    /**
     * <p>进场时间</p>
     * <p>格式: yyyy-MM-dd HH:mm:ss</p>
     * <p>必填: 是</p>
     */
    protected String inTime;
    /**
     * <p>入场编号</p>
     * <p>必填: 是</p>
     */
    protected String inChannel;
    /**
     * <p>入场照片URL</p>
     * <p>路径要求：停车场编号/yyyyMMdd/文件名</p>
     * <p>必填: 是</p>
     */
    protected String inPicName;
    /**
     * <p>车辆颜色</p>
     * <p>0:"白",1:"灰(银)",2:"黄",3:"粉",4:"红",5:"绿",6:"蓝",7:"棕"</p>
     * <p>必填: 否</p>
     */
    protected Integer carColor;
    /**
     * <p>记录ID</p>
     * <p>停车场业务编号（业务编号为一次车辆到达离开的业务ID）</p>
     * <p>为保证唯一性可以考虑parkId+recordId</p>
     * <p>必填: 是</p>
     */
    protected String recordId;
    /**
     * <p>卡口id</p>
     * <p>必填: 是</p>
     */
    protected String tollgateID;
    /**
     * <p>摄像机id</p>
     * <p>必填: 是</p>
     */
    protected String cameraId;
    /**
     * <p>剩余车位数</p>
     * <p>必填: 是</p>
     */
    protected Integer freeCount;
}
