package com.icetech.partner.domain.request.tingjiandan;

import lombok.*;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotEmpty;

@Getter
@Setter
@ToString(callSuper = true)
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class GetInParkOrderInfoReq extends TingJianDanRequest {
    /**
     * 停车场ID
     */
    private String parkId;

    /**
     * 车牌号
     */
    private String carNum;

    /**
     * 停车场订单ID/号
     */
    @NotEmpty(message = "停车场订单不能为空")
    private String tradeId;

    /**
     * 用户操作渠道
     */
    @NotEmpty(message = "用户操作渠道不能为空")
    private String opChannel;
}
